#ifndef LCD_4BIT_h
#define LCD_4BIT_h

#include <inttypes.h>

// Format of Print
#define 	DEC   10						// Decimal
#define 	HEX   16						// Hex
#define 	OCT   8						// Oct
#define 	BIN   2						// Binary
#define     BCD   1                             	// BCD
#define 	BYTE  0						// Byte

//Command Code For Character LCD
#define  	lcd_clear_screen 		0x01			// Clear Display
#define  	lcd_cursor_home    	0x02			// Set Cursor = 0
#define  	lcd_display_on     	0x0E			// LCD Display Enable
#define  	lcd_display_off    	0x08			// LCD Display Disable
#define  	lcd_cursor_blink   	0x0F			// Set Cursor = Blink
#define  	lcd_cursor_on      	0x0E			// Enable LCD Cursor
#define  	lcd_cursor_off     	0x0C			// Disable LCD Cursor
#define  	lcd_cursor_left    	0x10			// Shift Left Cursor
#define  	lcd_cursor_right   	0x14			// Shift Right Cursor
#define  	lcd_display_sleft  	0x18			// Shift Left Display
#define 	lcd_display_sright 	0x1C			// Shift Right Display

class LCD_4BIT 
{
public:
  LCD_4BIT(int rs_pin, int rw_pin, int en_pin,
           int d4_pin, int d5_pin, int d6_pin, int d7_pin); // Signal Interface Used R/W Pin
  LCD_4BIT(int rs_pin, int en_pin,
           int d4_pin, int d5_pin, int d6_pin, int d7_pin); // Signal Interface Not Used R/W Pin
  void Initial(void);  			 				// Initial LCD Display
  void Command(int value);  						// Write Command
  void Print(char);
  void Print(const char[]);
  void Print(uint8_t);
  void Print(int);
  void Print(unsigned int);
  void Print(long);
  void Print(unsigned long);
  void Print(long, int);
  void SetCursor(int Cursor);						// Set Cursor(Set DDRAM Address)
  void ClearScreen(void);						// Clear Screen Display
  void ClearLCD(int Cursor, int length);       			// Clear LCD From Cursor with length
  int  ReadDisplay(void);						// Read Display(ASCII) LCD
  int  ReadAddress(void);                                   // Read Address & Busy LCD

private:
  bool _Used_RW_Pin;
  int  _rs_pin;
  int  _rw_pin;
  int  _en_pin;
  int  _data_pin[4];
  void _Busy_LCD(bool lcd_command);
  int  _ReadLCD(bool lcd_command);					// False=Data, True=Command
  void _Write_LCD_Byte(int value, bool lcd_command);		// Write Byte(Data,Command) to LCD
  void _Write_LCD_Nibble(int nibble, bool lcd_command);	// Write Nibble(4 Bit Data) to LCD
  void _printNumber(unsigned long, uint8_t);
};

#endif
